#ifdef _VERSION_CHECK_
	#ifndef MSET

		#ifndef _NOT_INSTANCED_
		
			#version 120
			#extension GL_EXT_gpu_shader4 : enable          
		
		#endif
			
	#endif
#endif

#ifdef SKINNING
	uniform samplerBuffer 	boneMatrices;
#endif

#ifndef _NOT_INSTANCED_
	uniform samplerBuffer 	WorldPoses;
#endif

varying vec2 	texcoord;
uniform vec2	tscale;
uniform vec2	tofs;
varying vec2	alphacoords;

uniform float 	fade;
uniform float 	alpha;
varying float	fadeAlpha;
uniform vec4	colorMod;	

attribute vec3	s2_vertex;
attribute vec3	s2_normal; 
attribute vec4	s2_color;
attribute vec4  s2_secondaryColor;
attribute vec4	s2_texcoords; 

//uniform float	bias;

vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

void main()
{
	vec4 vertex=vec4(s2_vertex,1.0);

#ifdef SKINNING

	vec4 index  		= s2_secondaryColor;
	vec4 weight 		= s2_color;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	mat4 TM;

	int j;
  	for( int i = 0; i < 4; i++ )
 	{
		j=int(index[i])*4;
		TM[0]=texelFetchBuffer(boneMatrices,j);
		TM[1]=texelFetchBuffer(boneMatrices,j+1);
		TM[2]=texelFetchBuffer(boneMatrices,j+2);
		TM[3]=texelFetchBuffer(boneMatrices,j+3);
		
		position = position + (TM * vertex) *weight[i];
	}
	
	//position.xyz=position.xyz+s2_normal.xyz*bias;
	gl_Position = gl_ModelViewProjectionMatrix * position;
	//gl_Position.z-=bias;

#else

	#ifndef _NOT_INSTANCED_
		mat4 MTX;
		int index=gl_InstanceID*4;
		MTX[0]=texelFetchBuffer(WorldPoses,index);
		MTX[1]=texelFetchBuffer(WorldPoses,index+1);
		MTX[2]=texelFetchBuffer(WorldPoses,index+2);
		MTX[3]=texelFetchBuffer(WorldPoses,index+3);
		fadeAlpha=MTX[3].w;
		MTX[3].w=1.0;
		
//		vertex.xyz=vertex.xyz+s2_normal.xyz*bias;	
		vertex.xyz=(MTX*vertex).xyz;//+(MTX*vec4(s2_normal.xyz,0.0)).xyz*bias;	
		
		//vec4 pos=MTX*vertex;		
		gl_Position = (gl_ModelViewProjectionMatrix)*vertex;//pos;
		
		//MTX=gl_ModelViewMatrix*MTX;
		vec4 pos=/*MTX*/gl_ModelViewMatrix*vertex;
		float dist=(length(pos.xyz)-fadeAlpha*0.8)/(fadeAlpha*0.2);
		dist=(1.0 - (clamp(dist,0.0,1.0)));
		fadeAlpha=dist*alpha*colorMod.a;

		gl_Position.z-=0.1*dist;
		//gl_Position.z-=0.1;//bias;
	#else
	
		//vertex.xyz=vertex.xyz+s2_normal.xyz*bias;					
		gl_Position = (gl_ModelViewProjectionMatrix)*vertex;
		//gl_Position.z-=bias;
		
		vec4 pos=gl_ModelViewMatrix*vertex;
		float dist=(length(pos.xyz)-fade*0.8)/(fade*0.2);
		dist=(1.0 - (clamp(dist,0.0,1.0)));
		fadeAlpha=dist*alpha*colorMod.a;
		
		gl_Position.z-=0.1*dist;
		
	#endif

#endif
			
	texcoord = s2_texcoords.st*tscale+tofs;	
	alphacoords = s2_texcoords.st;
}